/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.service.serviceaction.repair.effectors.selectfrus;

import com.ibm.hwmca.fw.pa.problem.ProblemManager;
import com.ibm.hwmca.fw.service.managedsystem.fru.Fru;
import com.ibm.hwmca.fw.service.panel.CommonDataBean;
import com.ibm.hwmca.fw.service.panel.GenericGui;
import com.ibm.hwmca.fw.service.serviceaction.ServiceActionType;
import com.ibm.hwmca.fw.service.statetransition.Context;
import com.ibm.hwmca.fw.service.statetransition.Effector;
import com.ibm.hwmca.fw.service.statetransition.EffectorException;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import com.ibm.hwmca.xfw.service.SD;
import com.ibm.hwmca.xfw.service.panel.PBCommonEmptyFruList;
import com.ibm.hwmca.xfw.service.panel.PBCommonFruListExhausted;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class AutoFruSelection
implements Effector {
    private static final String TRACE_MASKT = "XRVXAFST";
    private static final String TRACE_MASKF = "XRVXAFSF";
    private static final String TRACE_MASKD = "XRVXAFSD";

    public void fire(Context context) throws EffectorException {
        Trace.trace(TRACE_MASKT, "-> AutoFruSelection.fire");
        try {
            Map userData = context.getUserData();
            List fruList = (List)userData.get("FRU_LIST");
            if (fruList != null) {
                Vector<Fru> selectedFrus = new Vector<Fru>();
                Iterator it = fruList.iterator();
                Integer currentFruBlockId = null;
                Integer selectedFruBlockId = null;
                boolean done = false;
                while (it.hasNext() && !done) {
                    Fru fru = (Fru)it.next();
                    Map fruProps = fru.getProperties();
                    Trace.trace(TRACE_MASKF, "AutoFruSelection.fire, processing FRU: " + fru);
                    Trace.trace(TRACE_MASKF, "AutoFruSelection.fire, FRU properties: " + fruProps);
                    Boolean exchangedFlag = (Boolean)fruProps.get("EXCHANGED");
                    exchangedFlag = exchangedFlag == null ? Boolean.FALSE : exchangedFlag;
                    Boolean selectedFlag = (Boolean)fruProps.get("SELECTED");
                    if (!(selectedFlag = selectedFlag == null ? Boolean.FALSE : selectedFlag).equals(Boolean.FALSE) || !exchangedFlag.equals(Boolean.FALSE)) continue;
                    currentFruBlockId = (Integer)fruProps.get("EXCHANGE_BLOCK");
                    if (selectedFruBlockId == null) {
                        selectedFruBlockId = currentFruBlockId;
                        fruProps.put("SELECTED", Boolean.TRUE);
                    }
                    if (selectedFruBlockId == null) {
                        selectedFrus.add(fru);
                        done = true;
                        continue;
                    }
                    if (!selectedFruBlockId.equals(currentFruBlockId)) continue;
                    fruProps.put("SELECTED", Boolean.TRUE);
                    selectedFrus.add(fru);
                }
                userData.put("SELECTED_FRUS", selectedFrus);
                if (selectedFrus.size() == 0) {
                    String serviceActionType = (String)userData.get("rvType");
                    if (serviceActionType.equals(ServiceActionType.REPAIR_PROBLEM.getValue())) {
                        GenericGui guiHandle = (GenericGui)userData.get("DISPLAY_HANDLE");
                        CommonDataBean bean = new PBCommonFruListExhausted();
                        bean = (CommonDataBean)guiHandle.replace("com.ibm.hwmca.fw.service.panel.res.CommonPanels", ((CommonDataBean)bean).getTemplateName(), bean, userData);
                        context.getVariable(SD.FRU_SELECTION_STATUS_VARIABLE).setValue(SD.FRU_LIST_EXHAUSTED);
                        Trace.trace(TRACE_MASKF, "AutoFruSelection.fire, all frus exchanged? ...setting type 2");
                        context.getVariable(SD.OVERALL_STATUS_VARIABLE).setValue(SD.EXIT);
                    } else {
                        context.getVariable(SD.OVERALL_STATUS_VARIABLE).setValue(SD.PROBLEM_FIXED);
                    }
                } else {
                    context.getVariable(SD.FRU_SELECTION_STATUS_VARIABLE).setValue(SD.SELECTED);
                }
            } else {
                Trace.trace(TRACE_MASKF, "AutoFruSelection.fire, NO frus in the callout list?  Contact next level of support.");
                GenericGui guiHandle = (GenericGui)context.getUserData().get("DISPLAY_HANDLE");
                CommonDataBean bean = new PBCommonEmptyFruList();
                bean = (CommonDataBean)guiHandle.replace("com.ibm.hwmca.fw.service.panel.res.CommonPanels", ((CommonDataBean)bean).getTemplateName(), bean, userData);
                context.getVariable(SD.OVERALL_STATUS_VARIABLE).setValue(SD.EXIT);
            }
            Trace.trace(TRACE_MASKT, "<- AutoFruSelection.fire");
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "<-! AutoFruSelection.fire, exception caught: " + e);
            Trace.trace(TRACE_MASKT, e);
            if (!(e instanceof EffectorException)) {
                throw new EffectorException(e);
            }
            throw (EffectorException)e;
        }
    }

    private void makeType2(Context context) throws EffectorException {
        try {
            Map userData = context.getUserData();
            ProblemManager pm = ProblemManager.getProblemManager();
            CommonProblem p = (CommonProblem)userData.get("SERVICEABLE_EVENT");
            p.setProblemType("2");
            pm.changed(p);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "<-! AutoFruSelection.makeType2, exception caught: " + e);
            Trace.trace(TRACE_MASKT, e);
            throw new EffectorException(e);
        }
    }
}

